IF OBJECT_ID('GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO') IS NULL 
BEGIN
	CREATE TABLE GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO(
		CD_CTR_ENVIO BIGINT NOT NULL,
		CD_CTR_RETORNO BIGINT NOT NULL);
END

GO

IF OBJECT_ID('PK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO') IS NULL 
BEGIN
	ALTER TABLE GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO ADD CONSTRAINT PK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO PRIMARY KEY (CD_CTR_ENVIO, CD_CTR_RETORNO);
END

GO

IF NOT EXISTS (SELECT * FROM SYS.indexes WHERE NAME = 'UK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_CD_CTR_ENVIO')
BEGIN
	CREATE UNIQUE INDEX UK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_CD_CTR_ENVIO ON GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO(CD_CTR_ENVIO);
END

GO

IF NOT EXISTS (SELECT * FROM SYS.indexes WHERE NAME = 'UK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_CD_CTR_RETORNO')
BEGIN
	CREATE UNIQUE INDEX UK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_CD_CTR_RETORNO ON GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO(CD_CTR_RETORNO);
END

GO

IF OBJECT_ID('FK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_GT_ENVIO_EMITENTE') IS NULL 
BEGIN
	ALTER TABLE GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO ADD CONSTRAINT FK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_GT_ENVIO_EMITENTE FOREIGN KEY(CD_CTR_ENVIO) REFERENCES GT_ENVIO_EMITENTE(CD_CTR);
END

GO

IF OBJECT_ID('FK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_GT_RETORNO_CABECALHO') IS NULL 
BEGIN
	ALTER TABLE GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO ADD CONSTRAINT FK_GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO_GT_RETORNO_CABECALHO FOREIGN KEY(CD_CTR_RETORNO) REFERENCES GT_RETORNO_CABECALHO(CD_CTR);
END
